dataset_class='d4morl'
gpu=0
adpt_td_weight=0.001
adpt_steps=1000
adpt_lr=0.05
use_wandb=1
export WANDB_INIT_TIMEOUT="300"

for dataset_type in  expert_uniform  amateur_uniform 
do
    
    for env in  MO-Swimmer-v2 MO-HalfCheetah-v2 MO-Walker2d-v2  MO-Hopper-v2 MO-Ant-v2  
    do
        seed=0

        algo='Diffusion-QL'
        normalize_states=1
        pref_perturb_theta=0.0
        policy_freq=2
        nohup python train_eval.py \
            --env $env --dataset_type $dataset_type \
            --seed $seed \
            --dataset $dataset_class \
            --gpu $gpu \
            --use_wandb $use_wandb \
            --pref_perturb_theta $pref_perturb_theta \
            --algo $algo\
            --normalize_states $normalize_states\
            --adpt_td_weight $adpt_td_weight\
            --adpt_lr $adpt_lr\
            --adpt_steps $adpt_steps\
            --policy_freq $policy_freq\
            > logs/${env}_${dataset_type}_${seed}.txt &
        seed=$(($seed+1))
        gpu=$(($gpu+1))

        algo='PEDA'
        normalize_states=1
        pref_perturb_theta=0.0
        time_steps=200000
        nohup python train_eval.py \
            --env $env --dataset_type $dataset_type \
            --time_steps $time_steps\
            --seed $seed \
            --dataset $dataset_class \
            --gpu $gpu \
            --use_wandb $use_wandb \
            --pref_perturb_theta $pref_perturb_theta \
            --algo $algo\
            --normalize_states $normalize_states\
            --adpt_td_weight $adpt_td_weight\
            --adpt_lr $adpt_lr\
            --adpt_steps $adpt_steps\
            > logs/${env}_${dataset_type}_${seed}.txt &
        seed=$(($seed+1))
        gpu=$(($gpu+1))
    done
done   
